/*
 * 功能    : 查询表单验证、提交
 * 编辑时间：2014-03-31
 * 作者    ：Arvin.chen@zkteco.com
 */

$(document).on( "pagecreate", "#main_page", function() { //改变日期文本框
    var picker=$(".date",this);
    picker.attr('data-role',"datebox").attr('data-options','{"mode":"datebox"}').attr('placeholder',gettext("请选择日期"));
});

$(document).on("pageinit",function(){ //页面增强完成后为查询按钮绑定事件
   var app_label=$("#app_label").val();
   var app_menu=$("#app_menu").val();
   var model_name=$("#model_name").val();
   $("#id_search").unbind().click(function(){
     $("#error_info").empty();
     var dt=$('.date',"#main_page");
     if(valid_date(dt[0],dt[1])){
         var where=get_where();
         window.location.href="/"+app_label+"/page/"+app_menu+"/Wap"+model_name+"Report/?"+where.join('&');
    }
   });
});
var valid_date= function(start,end){  //验证选择日期的有效性
    if ($(start).val()=="" || $(end).val()==""){
     $("#error_info").append('<ul class="errorlist"><li>'+gettext("请选择开始日期和结束日期")+'</li></ul>');
        return false;
    }
    var st=new Date($(start).val().replace(/-/g,"/"));
    var et=new Date($(end).val().replace(/-/g,"/"));
    if(st>et){
     $("#error_info").append('<ul class="errorlist"><li>'+getext("开始日期不能大于结束日期")+'</li></ul>');
        return false;
    }
    if(et>new Date()){
     $("#error_info").append('<ul class="errorlist"><li>'+gettext("结束日期不能大于今天")+'</li></ul>');
        return false;
    }
    if(((et-st)>31*24*60*60*1000)|| (et.getMonth()>st.getMonth() && et.getDate()>=st.getDate())){
     $("#error_info").append('<ul class="errorlist"><li>'+gettext("时间跨度不能超过一个月！")+'</li></ul>');
        return false;
    }
    return true
}
var get_where = function(){ // 获取查询条件
	where = ["pure"]
	$("#main_content input").each(function(){
		if ($(this).attr("name")!= ""){
			where.push($(this).attr("name")+"="+$(this).val())
		}
	})
	return where;
}
